"use client";
import Image from "next/image";
import React from "react";
import certificateErrorImg from "../../../../../../public/assets/CERTIFICATE-2nd-variation.png";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faDownload } from "@fortawesome/free-solid-svg-icons";
import Notifications from "@/app/components/notifications/Notifications";
import SearchBox from "@/app/components/searchBox/SearchBox";
import { useGetCertificatesQuery } from "@/services/Api";
import LoaderCircle from "@/app/components/loaderCircle/loaderCircle";

const AllCertifications = () => {
  const { data, isLoading } = useGetCertificatesQuery();
  const certificates = data?.certificates;

  const downloadImage = async (url, filename = "certificate.png") => {
    try {
      const res = await fetch(url);
      const blob = await res.blob();
      const link = document.createElement("a");
      link.href = window.URL.createObjectURL(blob);
      link.download = filename;
      link.click();
      window.URL.revokeObjectURL(link.href);
    } catch (error) {
      console.error("Download failed:", error);
    }
  };

  const certImg = certificates?.license || certificateErrorImg;
  return (
    <div className="md:px-[28px] px-3 pb-8 min-h-screen">
      <h1 className="py-2 text-[34px] font-bold">All Certificate</h1>
      <div className="flex items-center justify-between gap-8 ">
        <div>
          <SearchBox />
        </div>
        <div className="flex items-center gap-2 text-darkgrey">
          <Notifications />
        </div>
      </div>
      <div className=" bg-[#FFFAFA] mt-3 p-4 rounded-xl">
        <div className="flex justify-between items-center mt-4">
          <p className="text-[20px] font-bold">
            Here is your achievements (Completed Courses)
          </p>
        </div>
        <div className="mt-4 grid lg:grid-cols-4 place-items-center md:grid-cols-3 sm:grid-cols-2 grid-cols-1 min-h-[314px] xl:gap-x-10 gap-x-4 gap-y-4">
          {isLoading ? (
            <div className="pr-2 h-[280px] flex justify-center items-center">
              <LoaderCircle />
            </div>
          ) : certificates?.length > 0 ? (
            certificates?.map((certificate, index) => (
              <div className="w-full" key={index}>
                <div>
                  <img
                    src={certificate?.license || certificateErrorImg}
                    alt="certificate"
                    width={400}
                    height={300}
                    className="w-full rounded-lg"
                    onError={(e) => {
                      e.currentTarget.src = certificateErrorImg.src;
                    }}
                  />
                  <div className="flex justify-between mt-3">
                    <p className="text-[#363636] font-bold">
                      {certificate?.course_name}
                    </p>
                    {/* 👇 download button */}
                    <button
                      className="text-blue-800"
                      onClick={() =>
                        downloadImage(
                          certificate?.license,
                          `${certificate?.course_name || "certificate"}.png`
                        )
                      }
                    >
                      <FontAwesomeIcon icon={faDownload} />
                    </button>
                  </div>
                </div>
              </div>
            ))
          ) : (
            <div className="p-4 mb-4 text-sm text-blue-800 rounded-lg bg-blue-50 dark:bg-gray-800 dark:text-blue-400 w-full lg:col-span-4 md:col-span-3 sm:col-span-2 col-span-1">
              No certificate found
            </div>
          )}
        </div>
      </div>
    </div>
  );
};

export default AllCertifications;

// "use client";
// import Image from "next/image";
// import React from "react";
// import certificate1 from "../../../../../../public/assets/dashboard/certification/image1.png";
// import certificate2 from "../../../../../../public/assets/dashboard/certification/image2.png";
// import certificate3 from "../../../../../../public/assets/dashboard/certification/image3.png";
// import certificate4 from "../../../../../../public/assets/dashboard/certification/image4.png";
// import certificateErrorImg from "../../../../../../public/assets/CERTIFICATE-2nd-variation.png";
// import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
// import { faDownload } from "@fortawesome/free-solid-svg-icons";
// import Notifications from "@/app/components/notifications/Notifications";
// import SearchBox from "@/app/components/searchBox/SearchBox";
// import { useGetCertificatesQuery } from "@/services/Api";

// const AllCertifications = () => {
//   const { data } = useGetCertificatesQuery();
//   const certificates = data?.certificates;
//   const [imgSrc, setImgSrc] = React.useState(
//     certificates?.license || certificateErrorImg
//   );

//   return (
//     <div className="md:px-[28px] px-3 pb-8 min-h-screen">
//       <h1 className="py-2 text-[34px] font-bold">All Certificate</h1>
//       <div className="flex items-center justify-between gap-8 ">
//         <div>
//           <SearchBox />
//         </div>
//         <div className="flex items-center gap-2 text-darkgrey">
//           <Notifications />
//         </div>
//       </div>
//       <div className=" bg-[#FFFAFA] mt-3 p-4 rounded-xl">
//         <div className="flex justify-between items-center mt-4">
//           <p className="text-[20px] font-bold">
//             Here is your achievements (Completed Courses)
//           </p>
//         </div>
//         <div className="mt-4 grid lg:grid-cols-4 place-items-center md:grid-cols-3 sm:grid-cols-2 grid-cols-1 min-h-[314px] xl:gap-x-10 gap-x-4 gap-y-4">
//           {certificates?.length > 0 ? (
//             certificates?.map((certificate, index) => (
//               <div className="w-full" key={index}>
//                 <div>
//                   <Image
//                     src={imgSrc}
//                     alt="certificate"
//                     className="w-full rounded-lg"
//                     onError={() => setImgSrc(certificate1)}
//                   />
//                   <div className="flex justify-between mt-3">
//                     <p className="text-[#363636] font-bold">
//                       {certificate?.course_name}
//                     </p>
//                     <button className="text-blue-800">
//                       <FontAwesomeIcon icon={faDownload} />
//                     </button>
//                   </div>
//                 </div>
//               </div>
//             ))
//           ) : (
//             <div className="p-4 mb-4 text-sm text-blue-800 rounded-lg bg-blue-50 dark:bg-gray-800 dark:text-blue-400 w-full lg:col-span-4 md:col-span-3 sm:col-span-2 col-span-1">
//               No certificate found
//             </div>
//           )}
//         </div>
//       </div>
//     </div>
//   );
// };

// export default AllCertifications;
